<?php
include 'include/config.php';
session_start();

// ============================
// Handle company form submit
// ============================
if (isset($_POST['save_company'])) {
    $company_name = trim($_POST['company_name']);
    $users_allow = intval($_POST['users_allow']);

    // Check if company already exists
    $check = mysqli_query($con, "SELECT * FROM company_access WHERE company_name='$company_name'");
    if (mysqli_num_rows($check) > 0) {
        mysqli_query($con, "UPDATE company_access SET users_allow=$users_allow WHERE company_name='$company_name'");
        $msg = "Company updated successfully!";
    } else {
        mysqli_query($con, "INSERT INTO company_access (company_name, users_allow) VALUES ('$company_name', $users_allow)");
        $msg = "Company added successfully!";
    }
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>Company Access - Super Admin</title>
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
    <link rel="stylesheet" href="assets/vendors/mdi/css/materialdesignicons.min.css" />
    <link rel="stylesheet" href="assets/vendors/flag-icon-css/css/flag-icon.min.css" />
    <link rel="stylesheet" href="assets/vendors/css/vendor.bundle.base.css" />
    <link rel="stylesheet" href="assets/vendors/font-awesome/css/font-awesome.min.css" />
    <link rel="stylesheet" href="assets/vendors/bootstrap-datepicker/bootstrap-datepicker.min.css" />
    <link rel="stylesheet" href="assets/css/style.css" />
    <link rel="shortcut icon" href="assets/images/favicon.png" />
</head>

<body>
    <div class="container-scroller">
        <?php include('include/sidebar.php'); ?>

        <div class="container-fluid page-body-wrapper">
            <?php include('include/header.php'); ?>
            <div class="content-wrapper">
                <div class="card shadow mt-4">
                    <div class="card-header bg-primary text-white">
                        <h3 class="mb-0">🏢 Company Access (Super Admin)</h3>
                    </div>
                    <div class="card-body">


                        <?php if (!empty($msg)) echo "<div class='alert alert-success'>$msg</div>"; ?>

                        <form method="POST">
                            <div class="col-md-6">
                                <label class="form-label fw-semibold">Company Name</label>
                                <input type="text" name="company_name" class="form-control" required>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label fw-semibold">Users Allowed</label>
                                <input type="number" name="users_allow" min="1" class="form-control" required>
                            </div>
                            <div class="text-center">
                                <button type="submit" name="save_company" class="btn btn-success px-4">Save Company</button>
                            </div>
                        </form>

                        <h5 class="fw-bold mt-4 mb-3">📋 Company List</h5>
                        <table class="table table-bordered table-striped text-center align-middle">
                            <thead class="table-primary">
                                <tr>
                                    <th>S.No</th>
                                    <th>Company Name</th>
                                    <th>Users Allowed</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $res = mysqli_query($con, "SELECT * FROM company_access ORDER BY id DESC");
                                $i = 1;
                                while ($row = mysqli_fetch_assoc($res)) {
                                    echo "<tr>
                      <td>{$i}</td>
                      <td>{$row['company_name']}</td>
                      <td>{$row['users_allow']}</td>
                    </tr>";
                                    $i++;
                                }
                                ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        <?php include('include/footer.php'); ?>

        </div>
    </div>
</body>

</html>